% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program fittingSATs.m
function [lamda, beta, delta, r2_full, r2_reduced, F, ...
      df1, df2,  p] = fittingSATs(SATs)  
        % SATs contains the measured SATs

NSATs = size(SATs, 1)/2;
Ndelays = size(SATs, 2);
data = SATs;

% full model fit
guess = [2*ones(1, NSATs) 4*ones(1, NSATs), ...
      0.30*ones(1, NSATs)]; % lamda, beta, delta
options = optimset('fminsearch');
[guess, fullmodel_L] = fminsearch('SATfull_costfunc', ...
      guess, options, data);

%reduced model: same delta for all SATs
guess = [3*ones(1, NSATs) 0.25*ones(1, NSATs), 0.20]; 
        % lamda, beta, delta
options = optimset('fminsearch');
[guess, reducedmodel_L] = fminsearch('SATreduced_costfunc', ...
      guess, options, data);
lamda= guess(1:NSATs);
beta = guess((NSATs+1):(2*NSATs));
delta = guess((2*NSATs+1));
meanLogS = mean(mean(SATs(2:2:NSATs, :)));
SS = sum(sum((SATs(2:2:NSATs,:) - meanLogS).^2));
r2_full = 1 - fullmodel_L/SS;
r2_reduced = 1 - reducedmodel_L/SS;
df1 = NSATs-1;
df2 = NSATs*Ndelays - 3*NSATs;
F = (r2_full - r2_reduced)/df1 / ((1 - r2_full)/df2);
p = 1 - fcdf(F, df1, df2);
